/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.reflect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicArrayState;
import org.apache.avro.perf.test.BasicRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class ReflectNestedObjectArrayTest {
    private static final int ARRAY_SIZE = 10;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        for (ObjectArrayWrapper r : state.testData) {
            state.datumWriter.write((Object)r, state.encoder);
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(Blackhole blackhole, TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        ReflectDatumReader datumReader = new ReflectDatumReader(state.schema);
        for (int i = 0; i < state.getBatchSize(); ++i) {
            blackhole.consume(datumReader.read(null, d));
        }
    }

    static BasicRecord[] populateRecordArray(Random r, int size) {
        BasicRecord[] result = new BasicRecord[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new BasicRecord(r);
        }
        return result;
    }

    static class ObjectArrayWrapper {
        BasicRecord[] value;

        ObjectArrayWrapper() {
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicArrayState {
        private final Schema schema;
        private byte[] testData;
        private Decoder decoder;

        public TestStateDecode() {
            super(10);
            String jsonText = ReflectData.get().getSchema(BasicRecord[].class).toString();
            this.schema = new Schema.Parser().parse(jsonText);
        }

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            ReflectDatumWriter writer = new ReflectDatumWriter(this.schema);
            for (int i = 0; i < this.getBatchSize(); ++i) {
                BasicRecord[] r = ReflectNestedObjectArrayTest.populateRecordArray(this.getRandom(), this.getArraySize());
                writer.write((Object)r, encoder);
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = DecoderFactory.get().validatingDecoder(this.schema, super.newDecoder(this.testData));
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicArrayState {
        private final Schema schema;
        private ObjectArrayWrapper[] testData;
        private Encoder encoder;
        private ReflectDatumWriter<ObjectArrayWrapper> datumWriter;

        public TestStateEncode() {
            super(10);
            String jsonText = ReflectData.get().getSchema(ObjectArrayWrapper.class).toString();
            this.schema = new Schema.Parser().parse(jsonText);
        }

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.datumWriter = new ReflectDatumWriter(this.schema);
            this.testData = new ObjectArrayWrapper[this.getBatchSize()];
            for (int i = 0; i < this.testData.length; ++i) {
                ObjectArrayWrapper wrapper = new ObjectArrayWrapper();
                wrapper.value = ReflectNestedObjectArrayTest.populateRecordArray(this.getRandom(), this.getArraySize());
                this.testData[i] = wrapper;
            }
        }
    }
}

