/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.WaiterFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class DisconnectingWaiterFactory<K>
extends WaiterFactory<K> {
    private static final Duration DEFAULT_TIME_BETWEEN_CONNECTION_CHECKS = Duration.ofMillis(100L);
    private static final Duration DEFAULT_MAX_WAIT = Duration.ofSeconds(10L);
    protected static final Consumer<PooledObject<Waiter>> DEFAULT_DISCONNECTED_LIFECYCLE_ACTION = w -> {};
    protected static final Supplier<PooledObject<Waiter>> DEFAULT_DISCONNECTED_CREATE_ACTION = () -> {
        DisconnectingWaiterFactory.waitForConnection(null, DEFAULT_TIME_BETWEEN_CONNECTION_CHECKS, DEFAULT_MAX_WAIT);
        return new DefaultPooledObject((Object)new Waiter(true, true, 0L));
    };
    protected static final Predicate<PooledObject<Waiter>> DEFAULT_DISCONNECTED_VALIDATION_ACTION = w -> false;
    private final AtomicBoolean connected = new AtomicBoolean(true);
    final Duration timeBetweenConnectionChecks = DEFAULT_TIME_BETWEEN_CONNECTION_CHECKS;
    final Duration maxWait = DEFAULT_MAX_WAIT;
    final Supplier<PooledObject<Waiter>> disconnectedCreateAction;
    final Consumer<PooledObject<Waiter>> disconnectedLifcycleAction;
    final Predicate<PooledObject<Waiter>> disconnectedValidationAction;

    private static void waitForConnection(AtomicBoolean connected, Duration timeBetweenConnectionChecks, Duration maxWait) {
        Instant start = Instant.now();
        while (!connected.get()) {
            try {
                Thread.sleep(timeBetweenConnectionChecks.toMillis());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (Duration.between(start, Instant.now()).compareTo(maxWait) <= 0) continue;
            throw new IllegalStateException(new TimeoutException("Timed out waiting for connection"));
        }
    }

    public DisconnectingWaiterFactory() {
        this(DEFAULT_DISCONNECTED_CREATE_ACTION, DEFAULT_DISCONNECTED_LIFECYCLE_ACTION, DEFAULT_DISCONNECTED_VALIDATION_ACTION);
    }

    public DisconnectingWaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency) {
        this(activateLatency, destroyLatency, makeLatency, passivateLatency, validateLatency, waiterLatency, Long.MAX_VALUE, Long.MAX_VALUE, 0.0);
    }

    public DisconnectingWaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency, long maxActive) {
        this(activateLatency, destroyLatency, makeLatency, passivateLatency, validateLatency, waiterLatency, maxActive, Long.MAX_VALUE, 0.0);
    }

    public DisconnectingWaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency, long maxActive, long maxActivePerKey, double passivateInvalidationProbability) {
        super(activateLatency, destroyLatency, makeLatency, passivateLatency, validateLatency, waiterLatency, maxActive, maxActivePerKey, passivateInvalidationProbability);
        this.disconnectedCreateAction = DEFAULT_DISCONNECTED_CREATE_ACTION;
        this.disconnectedLifcycleAction = DEFAULT_DISCONNECTED_LIFECYCLE_ACTION;
        this.disconnectedValidationAction = DEFAULT_DISCONNECTED_VALIDATION_ACTION;
    }

    public DisconnectingWaiterFactory(Supplier<PooledObject<Waiter>> disconnectedCreateAction, Consumer<PooledObject<Waiter>> disconnectedLifcycleAction, Predicate<PooledObject<Waiter>> disconnectedValidationAction) {
        super(0L, 0L, 0L, 0L, 0L, 0L, Integer.MAX_VALUE, Integer.MAX_VALUE, 0.0);
        this.disconnectedCreateAction = disconnectedCreateAction;
        this.disconnectedLifcycleAction = disconnectedLifcycleAction;
        this.disconnectedValidationAction = disconnectedValidationAction;
    }

    private void activate(PooledObject<Waiter> obj) {
        if (this.connected.get()) {
            super.activateObject(obj);
        } else {
            this.disconnectedLifcycleAction.accept(obj);
        }
    }

    @Override
    public void activateObject(K key, PooledObject<Waiter> obj) {
        this.activate(obj);
    }

    @Override
    public void activateObject(PooledObject<Waiter> obj) {
        this.activate(obj);
    }

    public void connect() {
        this.connected.set(true);
    }

    public void disconnect() {
        this.connected.set(false);
    }

    private PooledObject<Waiter> make() {
        if (this.connected.get()) {
            return super.makeObject();
        }
        return this.disconnectedCreateAction.get();
    }

    @Override
    public PooledObject<Waiter> makeObject() {
        return this.make();
    }

    @Override
    public PooledObject<Waiter> makeObject(K key) {
        return this.make();
    }

    private void passivate(PooledObject<Waiter> obj) {
        if (this.connected.get()) {
            super.passivateObject(obj);
        } else {
            this.disconnectedLifcycleAction.accept(obj);
        }
    }

    @Override
    public void passivateObject(K key, PooledObject<Waiter> obj) {
        this.passivate(obj);
    }

    @Override
    public void passivateObject(PooledObject<Waiter> obj) {
        this.passivate(obj);
    }

    private boolean validate(PooledObject<Waiter> obj) {
        if (this.connected.get()) {
            return super.validateObject(obj);
        }
        return this.disconnectedValidationAction.test(obj);
    }

    @Override
    public boolean validateObject(K key, PooledObject<Waiter> obj) {
        return this.validate(obj);
    }

    @Override
    public boolean validateObject(PooledObject<Waiter> obj) {
        return this.validate(obj);
    }
}

