/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.SimpleFontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;

public abstract class DescendantFontValidator<T extends FontContainer>
extends SimpleFontValidator<T> {
    public DescendantFontValidator(PreflightContext context, PDCIDFont font, T fContainer) {
        super(context, (PDFontLike)font, font.getCOSObject(), fContainer);
    }

    @Override
    protected void checkMandatoryField() {
        boolean arePresent = this.fontDictionary.containsKey(COSName.TYPE);
        arePresent &= this.fontDictionary.containsKey(COSName.SUBTYPE);
        arePresent &= this.fontDictionary.containsKey(COSName.BASE_FONT);
        arePresent &= this.fontDictionary.containsKey(COSName.CIDSYSTEMINFO);
        if (!(arePresent &= this.fontDictionary.containsKey(COSName.FONT_DESC))) {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": Required keys are missing"));
        }
        this.checkCIDSystemInfo(this.fontDictionary.getCOSDictionary(COSName.CIDSYSTEMINFO));
        this.checkCIDToGIDMap(this.fontDictionary.getDictionaryObject(COSName.CID_TO_GID_MAP));
    }

    protected void checkCIDSystemInfo(COSDictionary sysinfo) {
        if (sysinfo != null) {
            String reg = sysinfo.getString(COSName.REGISTRY);
            String ord = sysinfo.getString(COSName.ORDERING);
            COSBase sup = sysinfo.getDictionaryObject(COSName.SUPPLEMENT);
            if (reg == null || ord == null || !(sup instanceof COSInteger)) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.8"));
            }
        } else {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.8"));
        }
    }

    protected abstract void checkCIDToGIDMap(COSBase var1);

    protected void checkCIDToGIDMap(COSBase ctog, boolean mandatory) {
        if (ctog instanceof COSName) {
            if (!COSName.IDENTITY.equals((Object)ctog)) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.9", this.font.getName() + ": The CIDToGID entry is invalid"));
            }
        } else if (ctog instanceof COSStream) {
            try {
                COSInputStream is = ((COSStream)ctog).createInputStream();
                is.close();
            }
            catch (IOException e) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.9", this.font.getName() + ": error getting CIDToGIDMap", e));
            }
        } else if (mandatory) {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.9", this.font.getName() + ": mandatory CIDToGIDMap missing"));
        }
    }
}

