/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.client.apache.dubbo.processor.register;

import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.matcher.ApiRegisterProcessor;
import org.apache.shenyu.client.core.register.matcher.BaseAnnotationApiProcessor;
import org.apache.shenyu.client.dubbo.common.annotation.ShenyuDubboClient;

/**
 * ShenyuDubboProcessor.
 */
public class ShenyuDubboProcessor extends BaseAnnotationApiProcessor<ShenyuDubboClient> implements ApiRegisterProcessor {
    
    @Override
    public void process(final ApiBean apiBean, final ShenyuDubboClient annotation) {
        apiBean.setBeanPath(annotation.path().replace("*", ""));
        
    }
    
    @Override
    public void process(final ApiBean.ApiDefinition definition, final ShenyuDubboClient annotation) {
        definition.setMethodPath(annotation.path());
        
    }
    
    @Override
    public Class<ShenyuDubboClient> matchAnnotation() {
        return ShenyuDubboClient.class;
    }
}
