
# Compatibility Report

![semver PATCH](https://img.shields.io/badge/semver-PATCH-yellow?logo=semver "semver PATCH")

## Summary

> [!IMPORTANT]
>
> Compatible bug fixes found while checking backward compatibility of version `3.6.1` with the previous version `3.6.0`.

<details markdown="1">
<summary>Expand to see options used.</summary>

- **Report only summary**: No
- **Report only changes**: Yes
- **Report only binary-incompatible changes**: No
- **Access modifier filter**: `PROTECTED`
- **Old archives**:
  - ![uimaj-core 3.6.0](https://img.shields.io/badge/uimaj_core-3.6.0-blue "uimaj-core 3.6.0")
- **New archives**:
  - ![uimaj-core 3.6.1](https://img.shields.io/badge/uimaj_core-3.6.1-blue "uimaj-core 3.6.1")
- **Evaluate annotations**: Yes
- **Include synthetic classes and class members**: No
- **Include specific elements**: No
- **Exclude specific elements**: No
- **Ignore all missing classes**: No
- **Ignore specific missing classes**: Yes
  - `com\.strobel\..*`
  - `org\.apache\.logging\.log4j\..*`
- **Treat changes as errors**:
  - Any changes: No
  - Binary incompatible changes: No
  - Source incompatible changes: No
  - Incompatible changes caused by excluded classes: Yes
  - Semantically incompatible changes: No
  - Semantically incompatible changes, including development versions: No
- **Classpath mode**: `ONE_COMMON_CLASSPATH`
- **Old classpath**:
```

```
- **New classpath**:
```

```

</details>


## Results

| Status    | Type                                            | Serialization       | Compatibility Changes |
|-----------|-------------------------------------------------|---------------------|-----------------------|
| Unchanged | [org.apache.uima.resource.RelativePathResolver] | ![Not serializable] | ![Annotation modified] |

<details markdown="1">
<summary>Expand for details.</summary>

___

<a id="user-content-org.apache.uima.resource.relativepathresolver"></a>
### `org.apache.uima.resource.RelativePathResolver`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                   | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|------------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `RelativePathResolver` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type    | Method                         | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|---------|--------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`URL`] | `resolveRelativePath`([`URL`]) | [`Deprecated`]: **`since`**=**`"3.6.0"`** |        | ![Annotation modified] |


</details>


> [!WARNING]
>
> Certain classes, i.e. superclasses and interfaces that could not be found on the classpath were ignored.
>
> Hence changes caused by these superclasses and interfaces are not reflected in the output.

___

*Generated on: 2025-09-24 11:59:47.331+0200*.

[Annotation modified]: https://img.shields.io/badge/Annotation_modified-yellow "Annotation modified"
[No changes]: https://img.shields.io/badge/No_changes-green "No changes"
[Not serializable]: https://img.shields.io/badge/Not_serializable-green "Not serializable"
[`Deprecated`]: # "java.lang.Deprecated"
[`Object`]: # "java.lang.Object"
[`URL`]: # "java.net.URL"
[org.apache.uima.resource.RelativePathResolver]: #user-content-org.apache.uima.resource.relativepathresolver
